from __future__ import generators
import plus
import Arenas
import random
import Hazards
import math

class ClawTop(Arenas.SuperArena):
    "Welcome to the SEQUEL"
    name = "DSL Onslaught Arena"
    preview = "DSLOnslaught_Arena/dslonslaught_preview.bmp"
    game_types = ['DEATHMATCH', 'BATTLE ROYAL', 'TEAM MATCH']
    extent = (-13, 13, 14, -14)

    def __init__(self):
        Arenas.SuperArena.__init__(self, "Arenas/DSLOnslaught_Arena/arena2_2.gmf")
        #plus.Arena.__init__(self, "")
        plus.setBackColor(0,0,0)
        
        fov = 0.015
        self.AddStaticCamera("              Static Cam Overhead", (0, 30, -63), (1.5708,0), 72*fov)
        self.AddStaticCamera("              Static-1a", (0, 60, -20), (2.17, 0), 25*fov)
        self.AddStaticCamera("              Static-1b", (0, 60, -20), (2.17, 0), 35*fov)
        self.AddStaticCamera("              Static-1c", (0, 60, -20), (2.17, 0), 45*fov)

        self.AddWatchCamera("               WatchCam-1a", (-17, 20, -46), (6, 12, 50*fov, 30*fov))
        self.AddWatchCamera("               WatchCam-1b", (-17, 20, -46), (6, 12, 60*fov, 40*fov))
        self.AddWatchCamera("               WatchCam-2a", (17, 20, -81), (10, 12, 50*fov, 30*fov))
        self.AddWatchCamera("               WatchCam-2b", (17, 20, -81), (10, 12, 60*fov, 40*fov))
        self.AddWatchCamera("               Watch Pit-Cam", (0, 4, -63), (6, 12, 80*fov, 60*fov))

        self.players = ()
        
        
    def AddShadowReceivers(self):
        self.SetShadowSource(5.897, 19.159, 5.899)
        
        #Main Arena Floor Shadow Triangles
        self.AddShadowTriangle((-10.2877,0.676244,1.83754), (-12.4182,0.676244,12.4283), (-12.4182,0.676244,1.83754))
        self.AddShadowTriangle((-8.17686,0.676244,9.91855), (-8.17686,0.676244,12.4283), (-12.4182,0.676244,12.4283))
        self.AddShadowTriangle((-8.17686,0.676244,9.91855), (-12.4182,0.676244,12.4283), (-10.2877,0.676244,1.83754))
        self.AddShadowTriangle((2.25999,0.676244,12.4283), (-2.49123,0.676244,12.4283), (-2.49123,0.676244,9.91855))
        self.AddShadowTriangle((2.25999,0.676244,9.91855), (2.25999,0.676244,12.4283), (-2.49123,0.676244,9.91855))
        self.AddShadowTriangle((12.413,0.676244,12.4283), (7.93297,0.676244,12.4283), (7.93297,0.676244,9.91855))
        self.AddShadowTriangle((10.2878,0.676244,1.91641), (12.413,0.676244,12.4283), (7.93297,0.676244,9.91855))
        self.AddShadowTriangle((10.2878,0.676244,1.91641), (12.413,0.676244,1.91641), (12.413,0.676244,12.4283))
        self.AddShadowTriangle((8.17711,0.676244,-9.92447), (12.413,0.676244,-12.4279), (10.2878,0.676244,-1.93329))
        self.AddShadowTriangle((10.2878,0.676244,-1.93329), (12.413,0.676244,-12.4279), (12.413,0.676244,-1.93329))
        self.AddShadowTriangle((8.17711,0.676244,-9.92447), (8.17711,0.676244,-12.4279), (12.413,0.676244,-12.4279))
        self.AddShadowTriangle((-2.26871,0.676244,-12.4279), (2.49519,0.676244,-12.4279), (2.49519,0.676244,-9.92447))
        self.AddShadowTriangle((-2.26871,0.676244,-9.92447), (-2.26871,0.676244,-12.4279), (2.49519,0.676244,-9.92447))
        self.AddShadowTriangle((-12.4182,0.676244,-12.4279), (-7.93688,0.676244,-12.4279), (-7.93688,0.676244,-9.92447))
        self.AddShadowTriangle((-10.2877,0.676244,-1.8361), (-12.4182,0.676244,-12.4279), (-7.93688,0.676244,-9.92447))
        self.AddShadowTriangle((-10.2877,0.676244,-1.8361), (-12.4182,0.676244,-1.8361), (-12.4182,0.676244,-12.4279))
        self.AddShadowTriangle((-2.49123,0.676244,9.91855), (-8.17686,0.676244,9.91855), (-10.2877,0.676244,1.83754))
        self.AddShadowTriangle((2.49519,0.676244,-9.92447), (8.17711,0.676244,-9.92447), (10.2878,0.676244,-1.93329))
        self.AddShadowTriangle((10.2878,0.676244,-1.93329), (-10.2877,0.676244,-1.8361), (-2.26871,0.676244,-9.92447))
        self.AddShadowTriangle((10.2878,0.676244,1.91641), (7.93297,0.676244,9.91855), (2.25999,0.676244,9.91855))
        self.AddShadowTriangle((2.25999,0.676244,9.91855), (-2.49123,0.676244,9.91855), (-10.2877,0.676244,1.83754))
        self.AddShadowTriangle((10.2878,0.676244,1.91641), (2.25999,0.676244,9.91855), (-10.2877,0.676244,1.83754))
        self.AddShadowTriangle((10.2878,0.676244,-1.93329), (10.2878,0.676244,1.91641), (-10.2877,0.676244,1.83754))
        self.AddShadowTriangle((-10.2877,0.676244,-1.8361), (10.2878,0.676244,-1.93329), (-10.2877,0.676244,1.83754))
        self.AddShadowTriangle((-2.26871,0.676244,-9.92447), (2.49519,0.676244,-9.92447), (10.2878,0.676244,-1.93329))
        self.AddShadowTriangle((-10.2877,0.676244,-1.8361), (-7.93688,0.676244,-9.92447), (-2.26871,0.676244,-9.92447))
        
        #Hazard Shadow Triangles
        self.AddShadowTriangle((-8.0217,0.407085,-12.2193), (-2.21868,0.407085,-12.2193), (-2.21868,0.407085,-9.90302))
        self.AddShadowTriangle((-2.21868,0.407085,-9.90302), (-8.0217,0.407085,-9.90302), (-8.0217,0.407085,-12.2193))
        self.AddShadowTriangle((2.42165,0.407085,-12.2193), (8.22466,0.407085,-12.2193), (8.22466,0.407085,-9.90302))
        self.AddShadowTriangle((8.22466,0.407085,-9.90302), (2.42165,0.407085,-9.90302), (2.42165,0.407085,-12.2193))
        self.AddShadowTriangle((-8.24321,0.407085,9.84521), (-2.4402,0.407085,9.84521), (-2.4402,0.407085,12.1615))
        self.AddShadowTriangle((-2.4402,0.407085,12.1615), (-8.24321,0.407085,12.1615), (-8.24321,0.407085,9.84521))
        self.AddShadowTriangle((2.20013,0.407085,9.84521), (8.00315,0.407085,9.84521), (8.00315,0.407085,12.1615))
        self.AddShadowTriangle((8.00315,0.407085,12.1615), (2.20013,0.407085,12.1615), (2.20013,0.407085,9.84521))
        
    def Activate(self, on):
        if on: self.players = plus.getPlayers()
        
        Arenas.SuperArena.Activate(self, on)


    def Tick(self):
        # check to see if anyone has been "eliminated" by falling off the tabletop
        for each in self.players:
            if plus.getLocation(each)[1] < -6:
                plus.eliminatePlayer(each)

        return Arenas.SuperArena.Tick(self)
        
Arenas.register(ClawTop)
